//
//  ViewController.m
//  FaceDetectDemo
//
//  Created by richard on 14/10/2017.
//  Copyright © 2017 com.alipay.faceDetect. All rights reserved.
//

#import "ViewController.h"
#import <AliyunFaceAuthFacade/AliyunFaceAuthFacade.h>

@interface ViewController ()<UITextFieldDelegate > {
    NSString  *certifyId;
    UIActivityIndicatorView *_indicator;
    UIButton *_submitInfo; //开始认证的Button
}

@property(nonatomic,strong)UITextField *certifyIdResult;

@end

@implementation ViewController

- (void)viewDidLoad {
    [super viewDidLoad];
    
    UILabel *initLabelDesc = [[UILabel alloc] initWithFrame:CGRectMake(20, 90, 200, 30)];
    initLabelDesc.text = @"认证";
    initLabelDesc.font = [UIFont systemFontOfSize:15];
    initLabelDesc.textColor = [UIColor blueColor];
    [self.view addSubview:initLabelDesc];

    UIView *seperateView = [[UIView alloc] initWithFrame:CGRectMake(20, initLabelDesc.frame.size.height + initLabelDesc.frame.origin.y, self.view.frame.size.width - 40, 1)];
    seperateView.backgroundColor = [UIColor blueColor];
    [self.view addSubview:seperateView];

    //获取certifyId.
    _certifyIdResult = [[UITextField alloc] init];//[UIButton buttonWithType:UIButtonTypeSystem];
    [_certifyIdResult setFrame:CGRectMake(20/2, seperateView.frame.origin.y + 30 + 8, self.view.frame.size.width - 20, 20)];
    [_certifyIdResult setText:@"在demo代码中写入从服务端申请的certifyId"];
    [_certifyIdResult setFont:[UIFont systemFontOfSize:14]];
    [_certifyIdResult setTextAlignment:NSTextAlignmentCenter];
    [_certifyIdResult setContentMode:UIViewContentModeCenter];        
    [_certifyIdResult setTintColor:[UIColor blackColor]];
    [self.view addSubview:_certifyIdResult];
    
    UIButton *submitButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [submitButton setFrame:CGRectMake((self.view.frame.size.width - 140)/2, _certifyIdResult.frame.origin.y + _certifyIdResult.frame.size.height + 20, 140, 30)];
    [submitButton setTitle:@"开始刷脸认证" forState:UIControlStateNormal];
    [submitButton addTarget:self action:@selector(submitInfo) forControlEvents:UIControlEventTouchUpInside];
    submitButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [self.view addSubview:submitButton];
    _submitInfo = submitButton;

    [AliyunFaceAuthFacade init];// 初始化SDK。
    NSLog(@"getVersion --> %@",[AliyunFaceAuthFacade getVersion]);
}

- (void)submitInfo {
    certifyId = @"sha17484e8771b81699a5c3803eaa6de";
    if ([certifyId length] < 1) {
        [self alertInfomation:@"还未获取到certifyId"];
        return;
    }
    [_submitInfo setUserInteractionEnabled:NO];
    NSMutableDictionary  *extParams = [NSMutableDictionary new];
    [extParams setValue:self forKey:@"currentCtr"];
    __weak ViewController* weakSelf = self;
    [AliyunFaceAuthFacade verifyWith:certifyId extParams:extParams onCompletion:^(ZIMResponse *response) {
         dispatch_async(dispatch_get_main_queue(), ^{
             [weakSelf.certifyIdResult setText:[NSString stringWithFormat:@"需要重新获取certifyId=%@",certifyId]];
             NSString *title = @"刷脸成功";
             switch (response.code) {
                 case 1000:
                     break;
                 case 1003:
                     title = @"用户退出";
                     break;
                 case 2002:
                     title = @"网络错误";
                     break;
                 case 2006:
                     title = @"刷脸失败";
                     break;
                 default:
                     break;
             }
             NSLog(@"%@;主码：%d,子码：%@,子码描述信息：%@",title,(int)response.code,response.retCodeSub,response.retMessageSub);
             UIAlertController *alertController = [UIAlertController alertControllerWithTitle:title message:response.retMessageSub preferredStyle:UIAlertControllerStyleAlert];
             [alertController addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
                 [_submitInfo setUserInteractionEnabled:YES];
             }]];
             [self presentViewController:alertController animated:YES completion:nil];
         });
    }];
}

-(void)alertInfomation:(NSString*)title{
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:title message:nil preferredStyle:UIAlertControllerStyleAlert];
    [alertController addAction:[UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
    }]];
    [self presentViewController:alertController animated:YES completion:nil];
}

@end
