if (!("finalizeConstruction" in ViewPU.prototype)) {
    Reflect.set(ViewPU.prototype, "finalizeConstruction", () => { });
}
interface Index_Params {
    message?: string;
    certifyID?: string;
}
import { ZimConstant, ZimFacade } from "@normalized:N&&&@alipay/aliyunfacade/aliyunfacade&1.3.10-251015";
import type { ZimResponse } from "@normalized:N&&&@alipay/aliyunfacade/aliyunfacade&1.3.10-251015";
import HashMap from "@ohos:util.HashMap";
import { JSONUtil, StringUtil } from "@normalized:N&&&@alipay/authbase/authbase&1.3.10-2510151";
class Index extends ViewPU {
    constructor(parent, params, __localStorage, elmtId = -1, paramsLambda = undefined, extraInfo) {
        super(parent, __localStorage, elmtId, extraInfo);
        if (typeof paramsLambda === "function") {
            this.paramsGenerator_ = paramsLambda;
        }
        this.__message = new ObservedPropertySimplePU('发起认证', this, "message");
        this.__certifyID = new ObservedPropertySimplePU('', this, "certifyID");
        this.setInitiallyProvidedValue(params);
        this.finalizeConstruction();
    }
    setInitiallyProvidedValue(params: Index_Params) {
        if (params.message !== undefined) {
            this.message = params.message;
        }
        if (params.certifyID !== undefined) {
            this.certifyID = params.certifyID;
        }
    }
    updateStateVars(params: Index_Params) {
    }
    purgeVariableDependenciesOnElmtId(rmElmtId) {
        this.__message.purgeDependencyOnElmtId(rmElmtId);
        this.__certifyID.purgeDependencyOnElmtId(rmElmtId);
    }
    aboutToBeDeleted() {
        this.__message.aboutToBeDeleted();
        this.__certifyID.aboutToBeDeleted();
        SubscriberManager.Get().delete(this.id__());
        this.aboutToBeDeletedInternal();
    }
    private __message: ObservedPropertySimplePU<string>;
    get message() {
        return this.__message.get();
    }
    set message(newValue: string) {
        this.__message.set(newValue);
    }
    private __certifyID: ObservedPropertySimplePU<string>;
    get certifyID() {
        return this.__certifyID.get();
    }
    set certifyID(newValue: string) {
        this.__certifyID.set(newValue);
    }
    initialRender() {
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Row.create();
            Row.height('100%');
        }, Row);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Column.create();
            Column.width('100%');
        }, Column);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            TextInput.create({ placeholder: '请输入certifyID', text: this.certifyID });
            TextInput.onChange((value: string) => {
                this.certifyID = value;
            });
            TextInput.margin({ left: 20, right: 20 });
        }, TextInput);
        this.observeComponentCreation2((elmtId, isInitialRender) => {
            Button.createWithLabel(this.message);
            Button.fontSize(18);
            Button.fontWeight(FontWeight.Bold);
            Button.onClick((event: ClickEvent) => {
                let params: HashMap<string, string> = new HashMap();
                // SDK 全屏显示，默认为true
                params.set(ZimConstant.KEY_NEED_FULL_SCREEN, 'true');
                // SDK 展示对客弹窗信息，默认为true
                params.set(ZimConstant.KEY_USE_MESSAGE_BOX, 'true');
                ZimFacade.verify(this.getUIContext(), this.certifyID, {
                    onComplete: (response: ZimResponse) => {
                        let result: HashMap<string, string> = new HashMap();
                        result.set('code', response.code);
                        result.set('subCode', response.subCode);
                        result.set('msg', response.msg);
                        result.set('certifyID', this.certifyID);
                        AlertDialog.show({
                            title: '认证结果',
                            message: JSONUtil.parseMapToString(result),
                            autoCancel: true,
                            alignment: DialogAlignment.Bottom,
                            offset: { dx: 0, dy: -20 },
                            gridCount: 3,
                            confirm: {
                                value: '确定',
                                action: () => {
                                }
                            },
                            cancel: () => {
                            }
                        });
                        this.certifyID = '';
                        if (response.faceImage) {
                            result.set('faceImage', 'data:image/jpg;base64,' + StringUtil.base64Uint8Array(response.faceImage));
                        }
                        else {
                            result.set('faceImage', '');
                        }
                        let showParams: string = JSONUtil.parseMapToString(result);
                        console.log("Aliyun", showParams);
                    }
                }, params);
            });
            Button.margin({ top: 10 });
        }, Button);
        Button.pop();
        Column.pop();
        Row.pop();
    }
    aboutToAppear(): void {
        ZimFacade.init(getContext());
    }
    rerender() {
        this.updateDirtyElements();
    }
    static getEntryName(): string {
        return "Index";
    }
}
registerNamedRoute(() => new Index(undefined, {}), "", { bundleName: "com.dtf.facedemo", moduleName: "entry", pagePath: "pages/Index", pageFullPath: "entry/src/main/ets/pages/Index", integratedHsp: "false", moduleType: "followWithHap" });
