//
//  CustomConfigModel.h
//  AliyunIdentityPlatform
//
//  Created by 顾鹿 on 2024/9/4.
//  Copyright © 2024 aliyun.com. All rights reserved.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

@interface FaceConfig : NSObject

- (instancetype)initWithDictionary:(NSDictionary *)dict;

@property (nonatomic, strong) NSString *exitIconBase64;
@property (nonatomic, strong) NSString *faceBGColor;
@property (nonatomic, strong) NSString *faceTitleColor;
@property (nonatomic, strong) NSString *faceTipColor;
@property (nonatomic, strong) NSString *opFailedTitleColor;
@property (nonatomic, strong) NSString *opFailedTipColor;
@property (nonatomic, strong) NSString *opFailedConfirmColor;
@property (nonatomic, strong) NSString *faceProgressStartColor;
@property (nonatomic, strong) NSString *faceProgressEndColor;
@property (nonatomic, strong) NSString *exitAlertTitleColor;
@property (nonatomic, strong) NSString *exitAlertMessageColor;
@property (nonatomic, strong) NSString *exitAlertCancelColor;
@property (nonatomic, strong) NSString *exitAlertConfirmationColor;
@property (nonatomic, strong) NSString *timeoutAlertTitleColor;
@property (nonatomic, strong) NSString *timeoutAlertMessageColor;
@property (nonatomic, strong) NSString *timeoutAlertConfirmationColor;
@property (nonatomic, strong) NSString *tooManyRetriesAlertTitleColor;
@property (nonatomic, strong) NSString *tooManyRetriesAlertMessageColor;
@property (nonatomic, strong) NSString *tooManyRetriesAlertConfirmColor;
@property (nonatomic, strong) NSString *interruptedAlertTitleColor;
@property (nonatomic, strong) NSString *interruptedAlertMessageColor;
@property (nonatomic, strong) NSString *interruptedAlertConfirmColor;
@property (nonatomic, strong) NSString *permissionFailedAlertTitleColor;
@property (nonatomic, strong) NSString *permissionFailedAlertMessageColor;
@property (nonatomic, strong) NSString *permissionFailedAlertConfirmColor;
@property (nonatomic, strong) NSString *verifyNetworkErrorAlertTitleColor;
@property (nonatomic, strong) NSString *verifyNetworkErrorAlertMessageColor;
@property (nonatomic, strong) NSString *verifyNetworkErrorAlertConfirmColor;
@property (nonatomic, strong) NSString *verifyNetworkErrorAlertCancelColor;
@property (nonatomic, strong) NSString *verifyLoadingColor;

@property (nonatomic, strong) NSMutableArray *settingErrorKeyArray;
@property (nonatomic, strong) NSMutableArray *notIncludedKeyArray;
@end

@interface OcrConfig : NSObject

- (instancetype)initWithDictionary:(NSDictionary *)dict;


@property (nonatomic, strong) NSString *exitIconBase64;
@property (nonatomic, strong) NSString *albumBase64;
@property (nonatomic, strong) NSString *takePhotoBase64;
@property (nonatomic, strong) NSString *submitBase64;
@property (nonatomic, strong) NSString *ocrResultExitIconBase64;
@property (nonatomic, strong) NSString *ocrResultTipIconBase64;
@property (nonatomic, strong) NSString *ocrTitleColor;
@property (nonatomic, strong) NSString *ocrBorderColor;
@property (nonatomic, strong) NSString *ocrSubmitTitleColor;
@property (nonatomic, strong) NSString *ocrLoadingColor;
@property (nonatomic, strong) NSString *failedAlertTitleColor;
@property (nonatomic, strong) NSString *failedAlertMessageColor;
@property (nonatomic, strong) NSString *failedAlertCancelColor;
@property (nonatomic, strong) NSString *failedAlertConfirmationColor;
@property (nonatomic, strong) NSString *timeoutAlertTitleColor;
@property (nonatomic, strong) NSString *timeoutAlertMessageColor;
@property (nonatomic, strong) NSString *timeoutAlertConfirmationColor;
@property (nonatomic, strong) NSString *exitAlertTitleColor;
@property (nonatomic, strong) NSString *exitAlertCancelColor;
@property (nonatomic, strong) NSString *exitAlertConfirmationColor;
@property (nonatomic, strong) NSString *ocrResultTitleColor;
@property (nonatomic, strong) NSString *ocrResultTipBGColor;
@property (nonatomic, strong) NSString *ocrResultTipColor;
@property (nonatomic, strong) NSString *ocrResultInfoTitleColor;
@property (nonatomic, strong) NSString *ocrResultInfoContentColor;
@property (nonatomic, strong) NSString *ocrResultInfoBorderColor;
@property (nonatomic, strong) NSString *ocrResultTipTitleColor;
@property (nonatomic, strong) NSString *ocrResultErrorTipBGColor;
@property (nonatomic, strong) NSString *ocrResultConfirmBtnDisabledBGColor;
@property (nonatomic, strong) NSString *ocrResultConfirmBtnDisabledTitleColor;
@property (nonatomic, strong) NSString *ocrResultConfirmBtnEnabledBGColor;
@property (nonatomic, strong) NSString *ocrResultConfirmBtnEnabledTitleColor;
@property (nonatomic, strong) NSString *ocrResultExitAlertTitleColor;
@property (nonatomic, strong) NSString *ocrResultExitAlertCancelColor;
@property (nonatomic, strong) NSString *ocrResultExitAlertConfirmationColor;
@property (nonatomic, strong) NSString *ocrResultLoadingColor;
@property (nonatomic, strong) NSString *restrictionsAlertTitleColor;
@property (nonatomic, strong) NSString *restrictionsAlertMessageColor;
@property (nonatomic, strong) NSString *restrictionsAlertConfirmationColor;
@property (nonatomic, strong) NSString *permissionFailedAlertTitleColor;
@property (nonatomic, strong) NSString *permissionFailedAlertMessageColor;
@property (nonatomic, strong) NSString *permissionFailedAlertConfirmColor;
@property (nonatomic, strong) NSString *ocrNetworkErrorAlertTitleColor;
@property (nonatomic, strong) NSString *ocrNetworkErrorAlertMessageColor;
@property (nonatomic, strong) NSString *ocrNetworkErrorAlertCancelColor;
@property (nonatomic, strong) NSString *ocrNetworkErrorAlertConfirmColor;
@property (nonatomic, strong) NSString *docErrorAlertTitleColor;
@property (nonatomic, strong) NSString *docErrorAlertMessageColor;
@property (nonatomic, strong) NSString *docErrorAlertCancelColor;
@property (nonatomic, strong) NSString *docErrorAlertConfirmColor;
@property (nonatomic, strong) NSString *ocrResultNetworkErrorAlertTitleColor;
@property (nonatomic, strong) NSString *ocrResultNetworkErrorAlertMessageColor;
@property (nonatomic, strong) NSString *ocrResultNetworkErrorAlertConfirmColor;
@property (nonatomic, strong) NSString *ocrResultInfoErrorAlertMessageColor;
@property (nonatomic, strong) NSString *ocrResultInfoErrorAlertConfirmColor;
@property (nonatomic, strong) NSString *ocrResultInfoInputEditColor;

@property (nonatomic, strong) NSString *floodLightBase64;
@property (nonatomic, strong) NSString *unFloodLightBase64;
@property (nonatomic, strong) NSString *autoScanBase64;
@property (nonatomic, strong) NSString *takeShootBase64;

@property (nonatomic, strong) NSString *ocrGuideExitIconBase64;
//@property (nonatomic, strong) NSString *ocrGuideConfirmBtnBGColor;
//@property (nonatomic, strong) NSString *ocrGuideConfirmBtnTextColor;
@property (nonatomic, strong) NSString *ocrGuideTitleColor;
@property (nonatomic, strong) NSString *ocrGuideContentColor;
//@property (nonatomic, strong) NSString *ocrGuidePageControlColor;
@property (nonatomic, strong) NSString *ocrGuideStartBtnTextColor;
@property (nonatomic, strong) NSString *ocrGuideStartBtnDisableTextColor;
@property (nonatomic, strong) NSString *ocrGuideStartBtnBGColor;
@property (nonatomic, strong) NSString *ocrGuideStartBtnDisableBGColor;
//@property (nonatomic, strong) NSString *ocrGuideCurrentPageControlColor;
@property (nonatomic, strong) NSString *ocrGuideIndicatorUnSelectedColor;
@property (nonatomic, strong) NSString *ocrGuideIndicatorSelectedColor;

//nfc
@property (nonatomic, strong) NSString *nfcTitleColor;
@property (nonatomic, strong) NSString *nfcContentColor;
@property (nonatomic, strong) NSString *nfcConfirmBtnBGColor;
@property (nonatomic, strong) NSString *nfcConfirmBtnTextColor;

@property (nonatomic, strong) NSString *nfcInputCheckAlertTitleColor;
@property (nonatomic, strong) NSString *nfcInputCheckAlertMessageColor;
@property (nonatomic, strong) NSString *nfcInputCheckAlertConfirmColor;
//@property (nonatomic, strong) NSString *nfcInputCheckAlertCancelColor;
@property (nonatomic, strong) NSString *nfcInputPassportEditHintColor;
@property (nonatomic, strong) NSString *nfcInputBirthdayEditHintColor;
@property (nonatomic, strong) NSString *nfcInputValidityEditHintColor;
@property (nonatomic, strong) NSString *nfcInputPassportLabelColor;
@property (nonatomic, strong) NSString *nfcInputBirthdayLabelColor;
@property (nonatomic, strong) NSString *nfcInputValidityLabelColor;
@property (nonatomic, strong) NSString *nfcInputBirthdayEditColor;
@property (nonatomic, strong) NSString *nfcInputValidityEditColor;
@property (nonatomic, strong) NSString *nfcInputPassportEditColor;
@property (nonatomic, strong) NSString *nfcInputTitleColor;
@property (nonatomic, strong) NSString *nfcInputBackAlertTitleColor;
@property (nonatomic, strong) NSString *nfcInputBackAlertCancelColor;
@property (nonatomic, strong) NSString *nfcInputBackAlertConfirmColor;
@property (nonatomic, strong) NSString *nfcInputNextBtnTextSelectColor;
@property (nonatomic, strong) NSString *nfcInputNextBtnBGSelectColor;
@property (nonatomic, strong) NSString *nfcReadBackAlertTitleColor;
@property (nonatomic, strong) NSString *nfcReadBackAlertConfirmColor;
@property (nonatomic, strong) NSString *nfcReadBackAlertCancelColor;
@property (nonatomic, strong) NSString *ocrAlbumLabelColor;
@property (nonatomic, strong) NSString *ocrTakePhotoLabelColor;

@property (nonatomic, strong) NSString *nfcExitIconBase64;
//@property (nonatomic, strong) NSString *nfcGuidePageControlColor;
//@property (nonatomic, strong) NSString *nfcGuideCurrentPageControlColor;

@property (nonatomic, strong) NSMutableArray *settingErrorKeyArray;
@property (nonatomic, strong) NSMutableArray *notIncludedKeyArray;

@end

@interface CustomConfigModel : NSObject

@property (nonatomic, strong) FaceConfig *faceConfig;
@property (nonatomic, strong) OcrConfig *ocrConfig;

- (instancetype)initWithJSON:(NSString *)jsonString completion:(void (^)(BOOL success, NSError *error, NSDictionary *warningDict))completion;

@end


NS_ASSUME_NONNULL_END
