package com.example.aliyun_identity_demo;

import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;

import android.Manifest;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;

import com.idv.identity.platform.api.IdentityCallback;
import com.idv.identity.platform.api.IdentityPlatform;
import com.idv.identity.platform.api.IdentityResponse;
import com.idv.identity.platform.api.IdentityResponseCode;

import java.util.ArrayList;
import java.util.List;

public class MainActivity extends AppCompatActivity {
    private static String LOG_TAG = "AliyunIdentity";
    private static final int IDENTITY_PERMISSION_REQUEST_CODE = 1024;

    private static String[] identityPermissions = {
            Manifest.permission.CAMERA
    };

    // // This function needs to be implemented by the user
    private String sentMetaInfoAndGetTransactionId(String metaInfo) {
        String transactionId = "Get TransactionId from your server."; // replace it.
        return transactionId;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        // Get camera permission.
        handlePermissions();

        // Init SDK
        IdentityPlatform.getInstance().install(MainActivity.this);

        // Click button and start verify.
        Button btnAliyunIdentity = findViewById(R.id.btnAliyunIdentity);
        if (null != btnAliyunIdentity) {
            btnAliyunIdentity.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View view) {
                    String metaInfo = IdentityPlatform.getMetaInfo(MainActivity.this);
                    String transactionId = sentMetaInfoAndGetTransactionId(metaInfo);

                    IdentityPlatform.getInstance().verify(transactionId, null, new IdentityCallback() {
                        @Override
                        public boolean response(final IdentityResponse response) {
                            if (IdentityResponseCode.IDENTITY_SUCCESS == response.code) {
                                Toast.makeText(MainActivity.this,
                                        "Verify Success.",
                                        Toast.LENGTH_LONG).show();
                            } else {
                                Toast.makeText(MainActivity.this,
                                        "Verify Failed. ([" + response.code + "]" + response.message + ")",
                                        Toast.LENGTH_LONG).show();
                            }

                            return true;
                        }
                    });
                }
            });
        }
    }

    private List<String> genUnGrantedToygerPermissions() {
        List<String> requestPerms = new ArrayList<>();
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            for (String permission : identityPermissions) {
                if (PackageManager.PERMISSION_GRANTED != checkSelfPermission(permission)) {
                    requestPerms.add(permission);
                }
            }
        }

        return requestPerms;
    }

    private void handlePermissions() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            List<String> requestPerms = genUnGrantedToygerPermissions();
            if (requestPerms.size() > 0) {
                requestPermissions(requestPerms.toArray(new String[0]),
                        IDENTITY_PERMISSION_REQUEST_CODE);
            }
        }
    }

    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);

        List<String> perms = genUnGrantedToygerPermissions();
        if ((requestCode == IDENTITY_PERMISSION_REQUEST_CODE) && (perms.size() <= 0)) {
            Log.d(LOG_TAG, "Ppermissions are OK.");
        } else {
            StringBuilder unGrantedPermissions = new StringBuilder();
            for(String permission:perms){
                unGrantedPermissions.append(permission);
                unGrantedPermissions.append(",");
            }

            Log.d(LOG_TAG, "Ppermissions not granted: " + unGrantedPermissions.toString());
        }
    }
}