//
//  ViewController.m
//  iOS-demo
//
//  Created by 汪澌哲 on 2023/5/12.
//

#import "ViewController.h"
#import <AliyunIdentityPlatform/AliyunIdentityPlatform.h>

@interface ViewController ()
@property (nonatomic,strong) UITextField *textField;
@end

@implementation ViewController

- (void)viewDidLoad {
    [[AliyunIdentityPlatform sharedInstance] install];

    [super viewDidLoad];
    self.textField = [[UITextField alloc]initWithFrame:CGRectMake(16 , 50, [UIScreen mainScreen].bounds.size.width - 32, 40)];
    self.textField.borderStyle = UITextBorderStyleRoundedRect;
    self.textField.placeholder = @"请输入认证id";
    [self.view addSubview:self.textField];
    UIButton *button = [UIButton buttonWithType:UIButtonTypeSystem];
    button.frame = CGRectMake(50, 100, [UIScreen mainScreen].bounds.size.width - 100, 50);
    [button setTitle:@"开始认证" forState:UIControlStateNormal];
    [self.view addSubview:button];
    [button addTarget:self action:@selector(buttonClicked:) forControlEvents:UIControlEventTouchUpInside];

    // Do any additional setup after loading the view.
}
- (void)buttonClicked:(UIButton *)sender {
    NSString *metaInfo = [[AliyunIdentityPlatform sharedInstance] getMetaInfo];
    NSMutableDictionary *extParams = [NSMutableDictionary dictionary];
    [extParams setValue:self forKey:@""];
    [extParams setValue:@"zh-Hans" forKey:@"kIdentityParamKeyLanguage"];
    [extParams setValue:@"en" forKey:@"kIdentityParamKeyDefaultLanguage"];

    [[AliyunIdentityPlatform sharedInstance] verifyWithCertifyId:self.textField.text
                                       withCurrentViewController:self
                                                   withExtParams:nil
                                                        complete:^(AliyunIdentityVerifyRes *response) {
        NSString *resContent = [NSString stringWithFormat:@"Code=%d Message=%@", response.code, response.message];
    }];
}

@end
