import 'package:flutter/material.dart';
import 'dart:async';
import 'dart:io';

import 'package:flutter/services.dart';
import 'package:aliyun_face_plugin/aliyun_face_plugin.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  String _infos = 'Unknown';
  final _aliyunFacePlugin = AliyunFacePlugin();

  @override
  void initState() {
    super.initState();

    // 在 App 启动的早期调用 init 接口。
    Map<String, String> options = {"CustomUrl":"https://cloudauth-device.ap-southeast-5.aliyuncs.com",
      "CustomHost":"cloudauth-device.ap-southeast-5.aliyuncs.com"};
    _aliyunFacePlugin.initWithOptions(options);
  }

  Future<void> getMetaInfos() async {
    String metainfos;

    try {
      // 获取客户端metainfos，将信息发送到服务器端，调用服务器端相关接口获取认证ID，即CertifyId。
      metainfos = await _aliyunFacePlugin.getMetaInfos() ?? 'Unknown metainfos';
    } on PlatformException {
      metainfos = 'Failed to get metainfos.';
    }

    setState(() {
      _infos = "metainfos: " + metainfos;
    });
  }

  Future<void> setCustomUi() async {
    try {
      String config = "{\"faceConfig\":{ \"faceBGColor\": \"#FF33FF\"}}";
      await _aliyunFacePlugin.setCustomUI(config) ?? '-1,error';
    } on PlatformException {
      '-2,exception';
    }
  }

  Future<void> startVerify() async {
    String verifyResult;
    try {
      String transactionId = "hks5391d03c45cce4124880313b52bd2";
      Map<String, String> params = {
        "transactionId": transactionId,
      };
      if (Platform.isIOS) {
        params.addAll({"kIdentityParamKeyLanguage": "en"});
      } else if (Platform.isAndroid) {
        params.addAll({"SdkLanguage": "en"});
      }

      verifyResult = await _aliyunFacePlugin.verify(params) ?? '-1,error';
    } on PlatformException {
      verifyResult = '-2,exception';
    }

    setState(() {
      _infos = "verifyResult: " + verifyResult;
    });
  }

  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      home: Scaffold(
        appBar: AppBar(title: const Text('Aliyun face plugin demo')),
        body: Center(
            child: Column(children: <Widget>[
          Text('$_infos\n'),
          ElevatedButton(
              onPressed: () async {
                getMetaInfos();
              },
              child: Text("getMetaInfos")),
          ElevatedButton(
              onPressed: () async {
                startVerify();
              },
              child: Text("startVerify")),
          ElevatedButton(
              onPressed: () async {
                setCustomUi();
              },
              child: Text("setCutomUi")),
        ])),
      ),
    );
  }
}
