#import "AliyunFacePlugin.h"
#import <AliyunIdentityPlatform/AliyunIdentityPlatform.h>

@implementation AliyunFacePlugin
+ (void)registerWithRegistrar:(NSObject<FlutterPluginRegistrar>*)registrar {
  FlutterMethodChannel* channel = [FlutterMethodChannel
      methodChannelWithName:@"aliyun_face_plugin"
            binaryMessenger:[registrar messenger]];
  AliyunFacePlugin* instance = [[AliyunFacePlugin alloc] init];
  [registrar addMethodCallDelegate:instance channel:channel];
}

- (void)handleMethodCall:(FlutterMethodCall*)call result:(FlutterResult)result {
    if ([@"getPlatformVersion" isEqualToString:call.method]) {
        NSLog(@"enter getPlatformVersion");
        result([@"" stringByAppendingString:[[UIDevice currentDevice] systemVersion]]);
        return;
    }
    
    if ([@"init" isEqualToString:call.method]) {
        NSLog(@"enter init");
        [[AliyunIdentityPlatform sharedInstance] install];
        return;
    }
    
    if ([@"initWithOptions" isEqualToString:call.method]) {
        NSLog(@"enter init");
        
        id arguments = call.arguments;
        NSMutableDictionary *options = [NSMutableDictionary dictionaryWithDictionary:arguments];

        [[AliyunIdentityPlatform sharedInstance] installWithOptions:options];
        return;
    }
    

    if ([@"getMetaInfos" isEqualToString:call.method]) {
        NSLog(@"enter getMetaInfos");
        NSString *info = [[AliyunIdentityPlatform sharedInstance] getMetaInfo];
        result([@"" stringByAppendingString:info]);
        return;
    }
    
    if ([@"verify" isEqualToString:call.method]) {
        NSLog(@"enter verify");
        
        id arguments = call.arguments;
        NSString *transactionId = [arguments objectForKey:@"transactionId"];
        
        if (transactionId == nil || [transactionId length] == 0) {
            NSLog(@"transactionId is nil.");
            return;
        }
        NSLog(@"transactionId: %@.", transactionId);
        
        NSMutableDictionary *extParams = [arguments objectForKey:@"extParams"];
        UIViewController *vc = [self viewControllerWithWindow:nil];
        
         [[AliyunIdentityPlatform sharedInstance] verifyWithCertifyId:transactionId
                                                withCurrentViewController:vc
                                                  withExtParams:extParams
                                               complete:^(AliyunIdentityVerifyRes *response) {
             result([NSString stringWithFormat:@"%d,%@", response.code, response.message]);
         }];
        
        return;
    }
    if ([@"setCustomUI" isEqualToString:call.method]) {
        NSLog(@"enter setCustomUI");
        
        NSString *config = call.arguments;
        [[AliyunIdentityPlatform sharedInstance] setCustomUI:config complete:^(BOOL success, NSError * _Nullable error, NSDictionary *warningDict) {
            NSLog(@"%@",error.localizedDescription);
        }];
        return;
    }
    
    result(FlutterMethodNotImplemented);
}

#pragma mark - 辅助方法

- (NSString *)convertToJsonData:(NSDictionary *) dict {
    NSError *error;
    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:dict
                                        options:NSJSONWritingSortedKeys
                                        error:&error];
    NSString *jsonString;
    if (!jsonData) {
        NSLog(@"Error: %@", error);
    } else {
        jsonString = [[NSString alloc]initWithData:jsonData encoding:NSUTF8StringEncoding];
    }
    return jsonString;
}

- (UIViewController *) viewControllerWithWindow:(UIWindow *)window {
    UIWindow *windowToUse = window;
    if(windowToUse == nil) {
        for (UIWindow *windowF in [UIApplication sharedApplication].windows) {
            if (windowF.isKeyWindow) {
                windowToUse = windowF;
                break;
            }
        }
    }
    UIViewController *topViewController = windowToUse.rootViewController;
    while (topViewController.presentingViewController) {
        topViewController = topViewController.presentingViewController;
    }
    return  topViewController;
}

@end
