package com.aliyun.face.aliyun_face_plugin;

import androidx.annotation.NonNull;

import java.util.Map;

import android.content.Context;

import io.flutter.embedding.engine.plugins.FlutterPlugin;
import io.flutter.plugin.common.MethodCall;
import io.flutter.plugin.common.MethodChannel;
import io.flutter.plugin.common.MethodChannel.MethodCallHandler;
import io.flutter.plugin.common.MethodChannel.Result;
import io.flutter.Log;

import com.idv.identity.platform.api.IDTFacade;
import com.idv.identity.platform.api.IdentityPlatform;
import com.idv.identity.platform.api.IdentityResponse;
import com.idv.identity.platform.api.IdentityResponseCode;
import com.idv.identity.platform.api.IdentityCallback;

/**
 * AliyunFacePlugin
 */
public class AliyunFacePlugin implements FlutterPlugin, MethodCallHandler {
    /// The MethodChannel that will the communication between Flutter and native Android
    ///
    /// This local reference serves to register the plugin with the Flutter Engine and unregister it
    /// when the Flutter Engine is detached from the Activity
    private MethodChannel channel;
    private Context mContext;
    private static String TAG = "AliyunFace";

    @Override
    public void onAttachedToEngine(@NonNull FlutterPluginBinding flutterPluginBinding) {
        channel = new MethodChannel(flutterPluginBinding.getBinaryMessenger(), "aliyun_face_plugin");
        channel.setMethodCallHandler(this);
        mContext = flutterPluginBinding.getApplicationContext();
    }

    @Override
    public void onMethodCall(@NonNull MethodCall call, @NonNull Result result) {
        if (call.method.equals("getPlatformVersion")) {
            result.success("android " + android.os.Build.VERSION.RELEASE);
        } else if (call.method.equals("init")) {
            Log.d(TAG, "enter init.");
            Map<String, String> params = call.arguments();
            if (params != null){
                IdentityPlatform.getInstance().install(mContext, params);
            }else {
                IdentityPlatform.getInstance().install(mContext);
            }
        } else if (call.method.equals("getMetaInfos")) {
            Log.d(TAG, "enter getMetaInfos.");
            String metaInfo = IdentityPlatform.getMetaInfo(mContext);
            result.success(metaInfo);
        } else if (call.method.equals("verify")) {
            Log.d(TAG, "enter verify.");
            Map<String, String> params = call.arguments();
            String transactionId = params.get("transactionId");
//            String transactionId = "hks651d7eae532342c4d617863b27a09";
            if (transactionId == null || transactionId.isEmpty()) {
                Log.e(TAG, "transactionId is null");
                return;
            }

            IdentityPlatform.getInstance().verify(transactionId, params, new IdentityCallback() {
                @Override
                public boolean response(final IdentityResponse response) {
                    if (null != response && 1000 == response.code) {
                        Log.d(TAG, "face verify success.");
                    } else {
                        Log.e(TAG, "face verify error.");
                    }

                    result.success(response.code + "," + response.message);
                    return true;
                }
            });
        } else if (call.method.equals("setCustomUI")) {
            Log.d(TAG, "enter setCustomUI.");
            String jsonConfig = call.arguments();
            int paramType = IDTFacade.EXT_PARAMS_CONFIG_JSON;
            String customUIErrMsg =  IdentityPlatform.getInstance().setCustomUIConfig(paramType, jsonConfig);
        }else {
            result.notImplemented();
        }
    }

    @Override
    public void onDetachedFromEngine(@NonNull FlutterPluginBinding binding) {
        channel.setMethodCallHandler(null);
    }
}
